﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma IgorVersion = 8
#pragma hide=1

// uncomment to debug
//#define DEBUG

// screen size margins
Static Constant imgTwintop = 50
Static Constant imgTwinleft = 50
Static Constant imgTwinheight = 600
Static Constant imgTwinwidth = 600

// ***
// STRUCTURES

// image dimensions
Structure S_ImgDimensions
	variable left
	variable right
	variable top
	variable bottom
EndStructure

// return imagesize
Function Sf_GetImgDimensions(sid)
	STRUCT S_ImgDimensions &sid
	
	wave cdimage = f_ImgwaveDisplayed()
	sid.left = DimOffset(cdimage,0)
	sid.right = sid.left + DimSize(cdimage,0)
	sid.top =  DimOffset(cdimage,1)
	sid.bottom = sid.top + DimSize(cdimage,1)
	return 0
end

// image window size
Structure S_ImgWinSize
	variable left
	variable top
	variable right
	variable bottom
EndStructure

// return window size
Function Sf_GetImgWinSize(siws)
	STRUCT S_ImgWinSize &siws

	variable pix = 72/ScreenResolution	
	variable resX, resY
	variable wintop, winleft, winbottom, winright
	string strinfo
	
	if (cmpstr(IgorInfo(2),"Macintosh") == 0)
		strinfo = StringByKey("RECT",ReplaceString(",RECT",StringByKey("SCREEN1",IgorInfo(0),":"),";RECT"),"=")
		resX = (Str2Num(StringFromList(2,strinfo,",")) - Str2Num(StringFromList(0,strinfo,",")))*pix
		resY = (Str2Num(StringFromList(3,strinfo,",")) - Str2Num(StringFromList(1,strinfo,",")))*pix
		wintop = imgTwintop + 10
	else
    GetWindow kwFrameInner wsizeDC
    resX = (v_right-v_left)
    resY = (v_bottom-v_top)
    wintop = imgTwintop
	endif
	
	winleft = imgTwinleft
	winright = limit(resX - imgTwinwidth, winleft + imgTwinwidth, inf)
	winbottom = limit(resY - imgTwinheight, wintop + imgTwinheight, inf)
	
	siws.left = pix*winleft
	siws.top = pix*wintop
	siws.right = pix*winright
	siws.bottom = pix*winbottom
	return 0
end

Structure S_ControlBarSettings
	string colorstr
	variable colorbar
	variable inverted
	variable scmin
	variable scmax
	variable scfull
EndStructure

Function Sf_GetControlBarSettings(scb)
	Struct S_ControlBarSettings &scb
	
	ControlInfo/W=$k_imgDisplay popupColor_CB
	scb.colorbar = v_value
	scb.colorstr = s_value
	ControlInfo/W=$k_imgDisplay checkInvert_CB
	scb.inverted = v_value
	ControlInfo/W=$k_imgDisplay sliderIMin_CB
	scb.scmin = v_value
	ControlInfo/W=$k_imgDisplay sliderIMax_CB
	scb.scmax = v_value
	ControlInfo/W=$k_imgDisplay checkMaxRange_CB
	scb.scfull = v_value

	return 0
end

Function Sf_RestoreControlBarSettings(scb)
	Struct S_ControlBarSettings &scb
	
	PopupMenu popupColor_CB, win=$k_imgDisplay, mode=scb.colorbar
	//scb.colorbar = v_value
	Checkbox checkInvert_CB, win=$k_imgDisplay, value=scb.inverted
	//scb.inverted = v_value
	Slider sliderIMin_CB, win=$k_imgDisplay, value=scb.scmin
	//scb.scmin = v_value
	Slider sliderIMax_CB, win=$k_imgDisplay, value=scb.scmax
	//scb.scmax = v_value
	Checkbox checkMaxRange_CB, win=$k_imgDisplay, value=scb.scfull
	//scb.scfull = v_value

	return 0
end

// image intensity values
Structure S_ImgIntensities
	variable imin
	variable imax
	variable iave
	variable istd
	variable roimin
	variable roimax
	variable roiave
	variable roistd
	variable roitotal
	variable cmin
	variable cmax
EndStructure

Function Sf_GetImgIntensities(sii)
	Struct S_ImgIntensities &sii
	
	string wdfstr = f_wdfstr(0) + ":imgT_hist:cimg_istats"
	
	NVAR/SDFR=$wdfstr gimin, gimax, giave, gistd
	NVAR/SDFR=$wdfstr groimax, groimin, groiave, groistd
	NVAR/SDFR=$wdfstr groitotal
	
	sii.imin = gimin
	sii.imax = gimax
	sii.iave = giave
	sii.istd = gistd
	sii.roimin = groimin
	sii.roimax = groimax
	sii.roiave = groiave
	sii.roistd = groistd
	sii.roitotal = groitotal
	
	return 0
end

Structure S_MaSSettings
	variable how
	variable hnegs
EndStructure

Function Sf_GetMaSSettings(mas)
	STRUCT S_MaSSettings &mas
	
	ControlInfo/W=$k_fullpanel popupMaSHow_tab24
	mas.how = v_value
	ControlInfo/W=$k_fullpanel popupMaSNegs_tab24
	mas.hnegs = v_value
	
	return 0
end

// structure to collect load instructions
Structure S_LoadSettings
	variable what
	variable source
	variable allow16bit
	variable red
	variable green
	variable blue
	variable gray
	variable graw
	variable howmany
	variable channels
	variable startimage
	variable stepimage
	variable endimage
	variable startindex
	variable stepindex
	variable asstack
	variable asfolder
	variable compressed
	variable loaderror
EndStructure

// populate the structure
Function Sf_GetLoadSettings(ls)
	STRUCT S_LoadSettings &ls

	// load what?
	ControlInfo/W=$k_fullpanel popupload_tab0
	ls.what = v_value
	
	// what type of image?
	ControlInfo/W=$k_fullpanel checkgraw_tab0
	ls.graw = v_value
	
	// extract what?
	ControlInfo/W=$k_fullpanel checkgred_tab0
	ls.red = v_value
	ControlInfo/W=$k_fullpanel checkggreen_tab0
	ls.green = v_value
	ControlInfo/W=$k_fullpanel checkgblue_tab0
	ls.blue = v_value
	ControlInfo/W=$k_fullpanel checkggray_tab0
	ls.gray = v_value
	
	// how many?
	ls.howmany = ls.graw + ls.red + ls.green + ls.blue + ls.gray
	if (ls.howmany > 0)
		if (ls.graw)
			ls.channels = 1
		else
			ls.channels = 3
		endif
	else
		ls.channels = 0
	endif
	
	// processing?
	ControlInfo/W=$k_fullpanel checkgsource_tab0
	ls.source = v_value
	ControlInfo/W=$k_fullpanel checkallow16bit_tab0
	ls.allow16bit = v_value
	
	ControlInfo/W=$k_fullpanel startimg_tab0
	ls.startimage = v_value
	ControlInfo/W=$k_fullpanel endimg_tab0
	ls.endimage = v_value
	ControlInfo/W=$k_fullpanel stepimg_tab0
	ls.stepimage = v_value
	ControlInfo/W=$k_fullpanel startind_tab0
	ls.startindex = v_value
	ControlInfo/W=$k_fullpanel stepind_tab0
	ls.stepindex = v_value
	
	ControlInfo/W=$k_fullpanel checkasstack_tab0
	ls.asstack = v_value
	ControlInfo/W=$k_fullpanel checkasfolder_tab0
	ls.asfolder = v_value

	ls.compressed = 0
	ls.loaderror = 0
	
	return 0
end

// structure to hold panel marquee readings
Structure S_MarqueeOnPanel
	variable left
	variable width
	variable top
	variable height
EndStructure

Function Sf_GetMQOnPanel(mqp)
	Struct S_MarqueeOnPanel &mqp
	
	ControlInfo/W=$k_fullpanel mqx0_tabM
	mqp.left = v_value
	ControlInfo/W=$k_fullpanel mqdx_tabM
	mqp.width = v_value
	ControlInfo/W=$k_fullpanel mqy0_tabM
	mqp.top = v_value
	ControlInfo/W=$k_fullpanel mqdy_tabM
	mqp.height = v_value
	
	return 0
end

// structure to collect marquee or hRoI coordinates
Structure S_MarqueeCoordinates
	variable hasmarquee
	variable hasdrawing
	variable ppleft
	variable ppright
	variable pptop
	variable ppbottom
	variable pgleft
	variable pgright
	variable pgtop
	variable pgbottom
	variable pgrleft
	variable pgrright
	variable pgrtop
	variable pgrbottom
	variable imgmag
	string pgsize
EndStructure

// fill the structure from drawing or image marquee
Function Sf_GetMQCoordinates(mc,[present])
	Struct S_MarqueeCoordinates &mc
	variable present
	
	variable pntsh, pxlsh, pntsppxl

	GetMarquee/W=$k_imgDisplay/Z
	mc.hasmarquee = v_flag
	
	if (!ParamIsDefault(present))
		return (mc.hasmarquee)
	endif
	
	mc.ppleft = NaN; mc.pptop = NaN; mc.ppright = NaN; mc.ppbottom = NaN
	mc.pgleft = NaN; mc.pgtop = NaN; mc.pgright = NaN; mc.pgbottom = NaN
	mc.pgrleft = NaN; mc.pgrtop = NaN; mc.pgrright = NaN; mc.pgrbottom = NaN
	mc.pgsize = ""
	
	GetWindow $k_imgDisplay expand
	mc.imgmag = v_value
	
	if (mc.hasmarquee == 1)
		GetMarquee/W=$k_imgDisplay	
		mc.ppleft = v_left
		mc.ppright = v_right
		mc.pptop = v_top
		mc.ppbottom = v_bottom
		GetMarquee/W=$k_imgDisplay left,top
		mc.pgleft = v_left
		mc.pgright = v_right
		mc.pgtop = v_top
		mc.pgbottom = v_bottom
		mc.pgrleft = round(v_left)
		mc.pgrright = round(v_right)
		mc.pgrtop = round(v_top)
		mc.pgrbottom = round(v_bottom)
		mc.pgsize = num2str(round(mc.pgleft+mc.pgright+mc.pgtop+mc.pgbottom))
#ifDEF DEBUG
		print "MQ from MARQUEE"
		print mc
#endif
	endif
	return mc.hasmarquee
end

// fill the structure from drawing
Function Sf_GetHRoICoordinates(mc,[present])
	Struct S_MarqueeCoordinates &mc
	variable present
	
	variable pntsh, pxlsh, pntsppxl

	DrawAction/W=$k_imgDisplay/L=ProgFront getgroup=hRoI, extractOutline
	mc.hasdrawing = v_flag
	
	if (!ParamIsDefault(present))
		return (mc.hasdrawing)
	endif
	
	mc.ppleft = NaN; mc.pptop = NaN; mc.ppright = NaN; mc.ppbottom = NaN
	mc.pgleft = NaN; mc.pgtop = NaN; mc.pgright = NaN; mc.pgbottom = NaN
	mc.pgrleft = NaN; mc.pgrtop = NaN; mc.pgrright = NaN; mc.pgrbottom = NaN

	// has a drawing
	if (mc.hasdrawing == 1)
		wave w_polyx, w_polyy
		mc.pgrleft=w_polyx[0]
		mc.pgrright=w_polyx[1]-1
		mc.pgrtop=w_polyy[1]
		mc.pgrbottom=w_polyy[2]
		getwindow $k_imgDisplay, psizeDC
		pxlsh = V_right-V_left
		getwindow $k_imgDisplay, psize
		pntsh = V_right-V_left
		pntsppxl = pntsh / pxlsh
		mc.ppleft = round(PixelFromAxisVal(k_imgDisplay,"left",mc.pgrleft)*pntsppxl)
		mc.pptop = round(PixelFromAxisVal(k_imgDisplay,"top",mc.pgrtop)*pntsppxl) + cbheight
		mc.ppright = round(PixelFromAxisVal(k_imgDisplay,"left",mc.pgrright)*pntsppxl)
		mc.ppbottom = round(PixelFromAxisVal(k_imgDisplay,"top",mc.pgrbottom)*pntsppxl) + cbheight
		mc.pgleft = mc.pgrleft
		mc.pgtop = mc.pgrtop
		mc.pgright = mc.pgrright
		mc.pgbottom = mc.pgrbottom
		killwaves/Z w_polyx, w_polyy
#ifDEF DEBUG
		print "MQ from DRAWING"
		print mc
#endif
	endif

	return mc.hasdrawing
end

// structure for maskop parameters
Structure S_MaskOPParams
	variable how
	variable level
	variable value
EndStructure

// function to get maskop parameters
Function Sf_GetMaskOPParams(mop)
	STRUCT S_MaskOPParams &mop
	
	ControlInfo/W=$k_fullPanel popupMaskOPHow_tab23
	mop.how = v_value
	ControlInfo/W=$k_fullPanel popupMaskOPLevel_tab23
	mop.level = v_value
	ControlInfo/W=$k_fullPanel setvarMaskOPLevel_tab23
	mop.value = v_value
	
	return 0
end

// background settings
Structure S_BackgroundParams
	variable plorder
	variable onplane
	variable negatives
	variable mrkred
	variable mrkgreen
	variable mrkblue
endStructure

Function Sf_GetBackgroundParams(sbg)
	STRUCT S_BackgroundParams &sbg
	
	ControlInfo/W=$k_fullpanel setvarPlOrder_tab21
	sbg.plorder = v_value
	ControlInfo/W=$k_fullpanel popupBckonStack_tab21
	sbg.onplane = v_value
	ControlInfo/W=$k_fullpanel popupBckNegs_tab21
	sbg.negatives = v_value
	ControlInfo/W=$k_fullpanel popupBckgPntColor_tab21
	sbg.mrkred = v_red
	sbg.mrkgreen = v_green
	sbg.mrkblue = v_blue
	
	return 0
end

// structure to store calibration variables
Structure S_CalibrateVariables
	// how: 1 pixel, 2 width, 3 height
	variable xyhow
	// panel inputs
	variable pivalue
	variable pilog
	// meters per pixel
	variable mpp
	// image xy size (meters)
	variable xyiwidth
	variable xyiheight
	// store as global
	variable asglobal
	// intensity
	variable ihow
	variable ionstack
	string ieqn
	variable bonstack
	variable fmax
EndStructure

Function Sf_GetCalibrationInputs(scv)
	STRUCT S_CalibrateVariables &scv

	ControlInfo/W=$k_fullpanel popupmethodxy_tab1
	scv.xyhow = v_value
	ControlInfo/W=$k_fullpanel psizem_tab1
	scv.pivalue = v_value
	ControlInfo/W=$k_fullpanel psizelm_tab1
	scv.pilog = v_value
	ControlInfo/W=$k_fullpanel checkxyglobal_tab1
	scv.asglobal = v_value
	ControlInfo/W=$k_fullpanel popupmethodcalI_tab1
	scv.ihow = v_value
	ControlInfo/W=$k_fullpanel popupIOnStack_tab1
	scv.ionstack = v_value
	ControlInfo/W=$k_fullpanel setvarcalIEQN_tab1
	scv.ieqn = s_value
	ControlInfo/W=$k_fullpanel popupBckOnStack_tab1
	scv.bonstack = v_value
	ControlInfo/W=$k_fullpanel setvarfmax_tab1
	scv.fmax = v_value

	return 0
end

Function Sf_SaveCalibrateVariables(scv)
	STRUCT S_CalibrateVariables &scv

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string iwf	
	
	DFREF cwd = GetDataFolderDFR()

	// always save local
	// (clumsy but future proof)
	iwf = "root:" + cwdfolder	
	SetDataFolder $iwf	
	NewDataFolder/O/S $k_pvfolder
	variable/G xyhow, mpp, xyiwidth, xyiheight, pivalue, pilog, ihow, ionstack, bonstack
	string/G ieqn
	SetDataFolder cwd
	iwf += ":" + k_pvfolder
	NVAR/SDFR=$iwf xyhow, mpp, xyiwidth, xyiheight, pivalue, pilog, ihow, ionstack, bonstack
	SVAR/SDFR=$iwf ieqn
	xyhow = scv.xyhow
	mpp = scv.mpp
	xyiwidth = scv.xyiwidth
	xyiheight = scv.xyiheight
	pivalue = scv.pivalue
	pilog = scv.pilog
	ihow = scv.ihow
	ionstack = scv.ionstack
	ieqn = scv.ieqn
	bonstack = scv.bonstack
	
	if (scv.asglobal)
		// validate/create globals anew each time
		// (clumsy but future proof)
		SetDataFolder pf
		NewDataFolder/O/S $k_pvfolder
		variable/G xyhow, mpp, xyiwidth, xyiheight, pivalue, pilog, ihow, ionstack, bonstack
		string/G ieqn
		SetDataFolder cwd
		iwf = k_fullpackageFolder + ":" + k_pvfolder
		NVAR/SDFR=$iwf xyhow, mpp, xyiwidth, xyiheight, pivalue, pilog, ihow, ionstack, bonstack
		SVAR/SDFR=$iwf ieqn
		xyhow = scv.xyhow
		mpp = scv.mpp
		pivalue = scv.pivalue
		pilog = scv.pilog
		xyiwidth = scv.xyiwidth
		xyiheight = scv.xyiheight
		ihow = scv.ihow
		ionstack = scv.ionstack
		ieqn = scv.ieqn
		bonstack = scv.bonstack
	endif
	
	return 0
end

// function to fix variable names
// lost translations in update from 1.x --> 2.x
// added fix for loss of ieqn in 2.x --> 3
// need: xyhow, pivalue, pilog, mpp, xyiwidth, xyiheight
// may have: xyhow, xympixel, xylmpixel, xyiwidth, xyliwidth
Function Sf_FixCalibrateVariables(wf)
	string wf
	
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder $wf
	if (exists("ieqn") != 2)
		string/G ieqn
	endif
	if (exists("xympixel") == 2)
		NVAR xympixel, xylmpixel, xyiwidth, xyliwidth
		Variable/G mpp
		xyiwidth *= 10^xyliwidth
		Rename xympixel pivalue
		Rename xylmpixel pilog
		Rename xyliwidth xyiheight
		Variable/G xyiheight
	 	xyiheight = xyiwidth
	endif
	SetDataFolder cdf
	return 0
end

// get calibration variables
// global take priority
Function Sf_RecallCalibrateVariables(scv)
	STRUCT S_CalibrateVariables &scv

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string iwf
	
	// check global
	if (DataFolderExists(k_fullpvfolder))
		iwf = k_fullpvfolder
		Sf_FixCalibrateVariables(iwf)		
		NVAR/SDFR=$iwf/Z xyhow, mpp, xyiwidth, xyiheight, pivalue, pilog, ihow, ionstack, bonstack
		SVAR/SDFR=$iwf/Z ieqn
		scv.xyhow = xyhow
		scv.mpp = mpp
		scv.xyiwidth = xyiwidth
		scv.xyiheight = xyiheight
		scv.pivalue = pivalue
		scv.pilog = pilog
		scv.ihow = ihow
		scv.ionstack = ionstack
		scv.ieqn = ieqn
		scv.bonstack = bonstack
		return 1
	endif
	
	// check local
	iwf = "root:" + cwdfolder + ":" + k_pvfolder
	if (DataFolderExists(iwf))
		// fix for update that did not correctly change parameter names
		Sf_FixCalibrateVariables(iwf)		
		NVAR/SDFR=$iwf/Z xyhow, mpp, xyiwidth, xyiheight, pivalue, pilog, ihow, ionstack, bonstack
		SVAR/SDFR=$iwf/Z ieqn
		scv.xyhow = xyhow
		scv.mpp = mpp
		scv.xyiwidth = xyiwidth
		scv.xyiheight = xyiheight
		scv.pivalue = pivalue
		scv.pilog = pilog
		scv.ihow = ihow
		scv.ionstack = ionstack
		scv.ieqn = ieqn
		scv.bonstack = bonstack
		return 0
	endif
	
	// neither local or global
	return -1
end

// structure for threshold parameters
Structure S_ThresholdParams
	variable method
	variable level
	variable range
	variable roi
	variable stZ
	variable oTP
	variable dofWhite
	variable doAuto
	variable onstack
EndStructure

// function to get threshold parameters
Function Sf_GetThresholdParams(thp)
	STRUCT S_ThresholdParams &thp
	
	ControlInfo/W=$k_fullPanel popupThresMethod_tab22
	thp.method = v_value-1
	ControlInfo/W=$k_fullPanel setvarThresLevel_tab22
	thp.level = v_value
	ControlInfo/W=$k_fullPanel setvarThresRange_tab22
	thp.range = v_value
	ControlInfo/W=$k_fullPanel popupThRoI_tab22
	thp.roi = v_value - 1
	ControlInfo/W=$k_fullPanel popupThMaskVal_tab22
	thp.stZ = v_value - 1
	ControlInfo/W=$k_fullPanel checkAutoThreshold_tab22
	thp.doAuto = v_value
	ControlInfo/W=$k_fullPanel popupThresOnPlane_tab22
	thp.oTP = v_value
	ControlInfo/W=$k_fullPanel checkdofWhite_tab22
	thp.dofWhite = v_value
	ControlInfo/W=$k_fullPanel popupThresOnPlane_tab22
	thp.onstack = v_value
	
	return 0
end
